/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/

(function () {
	'use strict';

	var csInterface = new CSInterface();
	var gExtensionId = "com.rayps.longshadowgenerator";

	themeManager.init();
	Persistent(true)
	hideDonateBtn()
	checkNewVersion("2.0")

	var L = 2
	var O = 20
	var C = true
	var F = true
	var A = 3

			
	$("#cover").click(function () {
		blurElement($("#container"),10)
		$("#about").animate({top:"80px"}, 500)
	});			
	$("#about .close").click(function () {
		blurElement($("#container"),0)
		$("#about").animate({top:"220px"}, 500)
	});


	$("#lsg-length .topcoat-range").on('change',function(event) {
		var thisVal = $(this).val()
		L = thisVal
		var calcVal = Math.pow(2, thisVal) * 10
		$("#lsg-length p").html(calcVal + " px")
	});

	$("#lsg-opacity .topcoat-range").on('change',function(event) {
		var thisVal = $(this).val()
		O = thisVal * 5
		$("#lsg-opacity p").html(O + " %")
	});

	$("#lsg-color").click(function(event) {
		C = $(".lsg-black").is(':checked')
	});


	$("#lsg-style").click(function(event) {
		F = $(".lsg-flat").is(':checked')
	});


	$("#lsg-angle").click(function() {
	    var aglbtn = $("#lsg-angle .topcoat-icon--large")
	    var deg = getRotationDegrees(aglbtn) + 90
	    A = (deg - 45).toString().charAt(0)
	    aglbtn.css("-webkit-transform", "rotate(" + deg + "deg)")
	})

	$("#lsg-button").click(function(event) {
		// $(this).html(L + " " + O + " " + C + " " + F + " " + A)
		csInterface.evalScript('LSG('+L+','+O+','+C+','+F+','+A+')')
	});


	$("#about .ray").click(function(event) {csInterface.openURLInDefaultBrowser("http://www.RayPS.com") });
	$("#about .mail").click(function(event) {csInterface.openURLInDefaultBrowser("mailto:ray@rayps.com") });
	$("#about .donate").click(function(event) {csInterface.openURLInDefaultBrowser("http://lab.rayps.com/donate/") });

	// FUNCTIONS -----------------------------------------------


	function Persistent(inOn) {
	    if (inOn){
	        var event = new CSEvent("com.adobe.PhotoshopPersistent", "APPLICATION");
	    } else {
	        var event = new CSEvent("com.adobe.PhotoshopUnPersistent", "APPLICATION");
	    }
	    event.extensionId = gExtensionId;
	    csInterface.dispatchEvent(event);
	}

	function checkNewVersion(currentVersion){
		$.getJSON('http://lab.rayps.com/lsg2/info.json', function(data) {
			if (currentVersion !== data.version) {
				$("#lsg-update").show().click(function(event) {
					csInterface.openURLInDefaultBrowser(data.update_url)
				})
			}
		})
	}

	function blurElement(element, size) {
		   var filterVal = 'blur(' + size + 'px)';
		   $(element)
		       .css('webkitFilter', filterVal)
		       .css('-webkit-transition', 'all 0.5s ease-out')
	 }

	 function hideDonateBtn() {
	 	$(".donate").hide()
	 	$("#about").css({
	 		"height": "60px",
	 		"margin-top": "40px"
	 	});
	 }

	function getRotationDegrees(obj) {
	    var matrix = obj.css("-webkit-transform")
	    if (matrix !== 'none') {
	        var values = matrix.split('(')[1].split(')')[0].split(',');
	        var a = values[0];
	        var b = values[1];
	        var angle = Math.round(Math.atan2(b, a) * (180 / Math.PI));
	    } else {
	        var angle = 0;
	    }
	    return (angle < 0) ? angle += 360 : angle;
	}

}());






